/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__wait_queue.h"

MX_FUNC(mx_return_t)
mx_wakeup(mx_endpoint_t ep)
{
#if MX_THREAD_SAFE
  struct mx__wait_queue *wq;
  uint32_t i;

  MX__MUTEX_LOCK(&ep->lock);

  while (!mx__wait_queue_isempty(&ep->wait_queue_head)) {
    wq = mx__wait_queue_dequeue(&ep->wait_queue_head);
    wq->wait_state = MX__WAIT_STATE_ABORTED;
    ep->wait_waiters--;
    MX__EVENT_SIGNAL(&wq->event);
  }

  for(i = 0; i < ep->ctxid_max; i++) {
    while (!mx__wait_queue_isempty(&ep->ctxid[i].peek_queue_head)) {
      wq = mx__wait_queue_dequeue(&ep->ctxid[i].peek_queue_head);
      wq->wait_state = MX__WAIT_STATE_ABORTED;
      ep->peek_waiters--;
      MX__EVENT_SIGNAL(&wq->event);
    }
    while (!mx__wait_queue_isempty(&ep->ctxid[i].probe_queue_head)) {
      wq = mx__wait_queue_dequeue(&ep->ctxid[i].probe_queue_head);
      wq->wait_state = MX__WAIT_STATE_ABORTED;
      ep->probe_waiters--;
      MX__EVENT_SIGNAL(&wq->event);
    }
  }

  mx_always_assert(!ep->wait_waiters);
  mx_always_assert(!ep->peek_waiters);
  mx_always_assert(!ep->probe_waiters);

  MX__MUTEX_UNLOCK(&ep->lock);
  return MX_SUCCESS;
#else
  return MX_SUCCESS;
#endif
}
